﻿'*******************************************************************************
'This program connects to the instrument and sends and receives commands.
'Enter the command and click the [Transmit and Receive] button to send it.
'If the command has a response (command contains "?"), the response is displayed in the textbox.
'
'Add Gpibvb.vb and SubFunc.vb to the project.
'These files are provided by Contec.
'Added GpibInputHioki function to SubFunc.vb.
'
'System requirements (software)
'   Microsoft Visual Studio Professional 2017
'   Microsoft.NET Framework 4.7
'*******************************************************************************

Public Class Form1

    Private comm As GPIB_CONTEC

    'Process for form load
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
        'Process for Enable/Disable on the buttons
        Button1.Enabled = True
        Button2.Enabled = False
        Button3.Enabled = False
        TextBox1.Enabled = False
        TextBox2.Enabled = True
        TextBox3.Enabled = False
        TextBox4.Enabled = False
        TextBox5.ReadOnly = True
    End Sub

    'Events when "Connect" button is clicked
    Private Sub Button1_Click(sender As System.Object, e As EventArgs) Handles Button1.Click
        'Create a GPIB object
        comm = New GPIB_CONTEC()

        'Connect
        If comm.OpenInterface(TextBox2.Text) = False Then
            Exit Sub
        End If

        'My address
        TextBox1.Text = comm.MyAddress.ToString()

        'Process for Enable/Disable on the buttons
        Button1.Enabled = False
        Button2.Enabled = True
        Button3.Enabled = True
        TextBox2.Enabled = False
        TextBox3.Enabled = True
        TextBox4.Enabled = True
    End Sub

    'Events when "Disconnect" button is clicked
    Private Sub Button2_Click(sender As System.Object, e As EventArgs) Handles Button2.Click
        'Disconnect
        comm.CloseInterface()

        'Process for Enable/Disable on the buttons
        Button1.Enabled = True
        Button2.Enabled = False
        Button3.Enabled = False
        TextBox2.Enabled = True
        TextBox3.Enabled = False
        TextBox4.Enabled = False
    End Sub

    'Events when "Transmit and Receive" button is clicked
    Private Sub Button3_Click(sender As System.Object, e As EventArgs) Handles Button3.Click
        Button3.Enabled = False

        TextBox5.AppendText("<< " + TextBox3.Text + vbCrLf)                             'Output logs of transmitting data
        comm.SendQueryMsg(TextBox3.Text, CLng(TextBox4.Text) * 1000)                    'Transmit and receive commands
        If InStr(TextBox3.Text, "?") <> 0 Then                                          'If the command contains "?"
            TextBox5.AppendText(">> " + comm.MsgBuf + vbCrLf)                           'Output logs of receiving data
        End If

        Button3.Enabled = True
    End Sub

    'Events when "Clear" button is clicked
    Private Sub Button4_Click(sender As System.Object, e As EventArgs) Handles Button4.Click
        'Clear the textbox
        TextBox5.Clear()
    End Sub

End Class

